import time
import pandas as pd
import os
from obspy import UTCDateTime
from Additional_Funs.features_fun import calc_features


tic = time.time()

# Reading CSV File

pwd_folder = os.getcwd()

mseed_folder = pwd_folder + '/Waveform_Data/'
mseed_file_name = 'VG.MEPAS.00.HHZ.D.2024.325.msd'

csv_folder_in = pwd_folder + '/Csv_Output_All_Detections/'
csv_file_name_in = 'Catalogue_MEPAS_2_20_20241120_0_24_hour.csv'

csv_folder_out = pwd_folder + '/Csv_Features/'
csv_file_name_out = 'Features_' + csv_file_name_in
path_csv_out = csv_folder_out + csv_file_name_out

df_detect = pd.read_csv(csv_folder_in + csv_file_name_in)
time_on_str = df_detect.iloc[:,1]
time_off_str = df_detect.iloc[:,2]

sz = time_on_str.shape[0]

# Define the desired column names
column_names = ['Event_ID', 'duration', 'mean_t', 'std_t', 'skew_t', 'kur_t', 'ratio_ad',
                'dominant_freq', 'median_dft']
num_rows = sz
df_features = pd.DataFrame(columns=column_names, index=range(num_rows))
df_features.iloc[:, 0] = df_detect.iloc[:, 0]

for j in range (sz):
    time_on_dt = UTCDateTime(time_on_str[j])
    time_off_dt = UTCDateTime(time_off_str[j])
    # print([time_on_dt, time_off_dt])
    tf_feat = calc_features((mseed_folder + mseed_file_name), time_on_dt, time_off_dt, j)
    df_features.iloc[j, 1:] = tf_feat

df_features.to_csv(path_csv_out, index=False)

toc = time.time()

elapsed_time = toc - tic
print('elapsed time is:" {:.3f}'.format(elapsed_time) +' seconds')